% Fit the MSD in several ways.
% (x,y)   The coordinates of the path
% Fit MSD(t) = A t + B
% Fit MSD(t) = A t
% Fit MSD(t) = a t^alpha + b
% Fit MSD(t) = a t^alpha
function [MSD_data, MSD_linearfits, MSD_nonlinfits,A1,B1,R1,A2,R2,a1,b1,r1,a2,r2,alpha1,alpha2,msd] = FitMSD(x,y,i)
%  d = 2;  % Spatial dimension
   K = 10; % Number of time intervals.
   N = length(x);
% Compute the MSD
   msd = [];
   for k = 1:K
      tmp = 0;
      for n = 1:N-k
         tmp = tmp + (x(n+k)-x(n))^2+(y(n+k)-y(n))^2;
      end
      msd = [msd,tmp/(N-k)];
   end
%  The time inverval.
   T = [1:1:K];
%  Compute the least squares fits
   t1 = mean(T);
   t2 = mean(T.^2);
   y1 = mean(msd);
   ty = mean(T.*msd);
% Fit MSD(t) = B + A t
   A1 = (t1*y1 - ty)/(t1^2 - t2);
   B1 = (t1*ty - t2*y1)/(t1^2 - t2);
   R1 = sqrt(mean((msd - (B1+A1*T)).^2));
% Fit MSD(t) = A t
   A2 = t1*y1/t1^2;
   R2 = sqrt(mean((msd - A1*T).^2));
% 
%  Least squares fits.
%
%  Fit MSD(t) = b + a t^alpha
%  params = [b,a,alpha]
   F = @(params,T,msd) sum((params(1)+params(2)*T.^params(3) - msd).^2);
%  Initial guess for the minimization.
   a1 = 5000;
   b1 = 0;
   alpha1 = 1;
   params = [b1,a1,alpha1];
%  Least squares fit.
   [params,fval,exitflag] = fminsearch(@(params) F(params,T,msd),params, ...
	 optimset('MaxFunEvals',1000000));
%  disp([i,exitflag]); disp(fval)
   b1 = params(1);
   a1 = params(2);
   alpha1 = params(3);
   r1 = sqrt(mean(F(params,T,msd)));
%
%  Fit MSD(t) = a t^alpha
%  params = [a,alpha]
   F = @(params,T,msd) sum((params(1)*T.^params(2) - msd).^2);
%  Initial guess for the minimization.
   a2 = 5000;
   alpha2  = 1;
   params = [a2,alpha2];
   [params,fval,exitflag] = fminsearch(@(params) F(params,T,msd),params, ...
	 optimset('MaxFunEvals',10000));
%   disp([i,exitflag]); disp(fval)
   a2 = params(1);
   alpha2 = params(2);
   r2 = sqrt(mean(F(params,T,msd)));
% 
%
figure(100+i)
set(gca,'fontsize',12)
hold on
plot(T,msd,'o')
plot([0,T],B1+A1*[0,T],'-b');
plot([0,T],A2*[0,T],'--r');
time = [0:1/10:K];
plot(time,max(0,b1+a1*time.^alpha1),'-.c');
plot(time,max(0,a2*time.^alpha2),'-m');
xlabel('n (frame number)');
ylabel('MSD (nm^2)');
legend('Data','MSD(n)=A*n+B', ...
              'MSD(n)=A*n', ...
              'MSD(n) = A*n^{\alpha}+B', ...
              'MSD(n) = A*n^{\alpha}', ...
              'Location','NorthWest');
tmp = [];
tmp = [tmp, 'MSD Fits for Experiment '];
tmp = [tmp, int2str(i)];
tmp = [tmp, '.'];
title(tmp);
print('-dpsc2', ['figures/MSDFIT',int2str(i)])
hold off
%close all

MSD_data = [];
MSD_data = [T', msd'];
MSD_linearfits = [];
MSD_linearfits = [[0,T]', B1+A1*[0,T]', A2*[0,T]']; 
MSD_nonlinfits = [];
MSD_nonlinfits = [time', max(0,b1+a1*time.^alpha1)', max(0,a2*time.^alpha2)'];